/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;

public abstract class MBeanServerAccessController
implements MBeanServerForwarder {
    private MBeanServer mbs;

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (this.mbs != null) {
            throw new IllegalArgumentException("MBeanServer object already initialized");
        }
        this.mbs = mbs;
    }

    protected abstract void checkRead();

    protected abstract void checkWrite();

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, params, signature);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, loaderName);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Object object = this.getMBeanServer().instantiate(className, loaderName, params, signature);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, name);
        }
        return this.getMBeanServer().createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        this.checkRead();
        return this.getMBeanServer().deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(className, loaderName, data);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttributes(name, attributes);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoader(loaderName);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderFor(mbeanName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderRepository();
    }

    public String getDefaultDomain() {
        this.checkRead();
        return this.getMBeanServer().getDefaultDomain();
    }

    public String[] getDomains() {
        this.checkRead();
        return this.getMBeanServer().getDomains();
    }

    public Integer getMBeanCount() {
        this.checkRead();
        return this.getMBeanServer().getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getObjectInstance(name);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, loaderName);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(className, loaderName, params, signature);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkWrite();
        this.checkMLetAddURL(name, operationName);
        return this.getMBeanServer().invoke(name, operationName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().isInstanceOf(name, className);
    }

    public boolean isRegistered(ObjectName name) {
        this.checkRead();
        return this.getMBeanServer().isRegistered(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.checkRead();
        return this.getMBeanServer().queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        this.checkRead();
        return this.getMBeanServer().queryNames(name, query);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkWrite();
        return this.getMBeanServer().registerMBean(object, name);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkWrite();
        this.getMBeanServer().setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkWrite();
        return this.getMBeanServer().setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkWrite();
        this.getMBeanServer().unregisterMBean(name);
    }

    private void checkClassLoader(Object object) {
        if (object instanceof ClassLoader) {
            throw new SecurityException("Access denied! Creating an MBean that is a ClassLoader is forbidden unless a security manager is installed.");
        }
    }

    private void checkMLetAddURL(ObjectName name, String operationName) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null && operationName.equals("addURL") && this.getMBeanServer().isInstanceOf(name, "javax.management.loading.MLet")) {
            throw new SecurityException("Access denied! MLet method addURL cannot be invoked unless a security manager is installed.");
        }
    }
}

