var setListeners = func {
    var prop = '/instrumentation/nav/nav-id';
    data.listeners[prop] = setlistener(prop,
            func (n) {
                var val = n.getValue();
                foreach (var c; keys(flightdeck))
                    flightdeck[c].display.updateNAV({'nav-id': 1, val: val});
            }, 1, 2);

    prop = '/instrumentation/nav[1]/nav-id';
    data.listeners[prop] = setlistener(prop,
            func (n) {
                var val = n.getValue();
                foreach (var c; keys(flightdeck))
                    flightdeck[c].display.updateNAV({'nav-id': 2, val: val});
            }, 1, 2);

    # keep this listener as long as the code is to heavy to be modified in multiple places
    prop = '/instrumentation/zkv1000/afcs/selected-alt-ft';
    data.listeners[prop] = setlistener(prop,
            func (n) {
                var val = n.getValue();
                if (val != nil)
                    foreach (var c; keys(flightdeck))
                        if (flightdeck[c].role == 'PFD') {
                            if (! flightdeck[c].display.screenElements['SelectedALT'].getVisible()) {
                                flightdeck[c].display.screenElements['SelectedALT'].show();
                                flightdeck[c].display.screenElements['SelectedALT-text'].show();
                                flightdeck[c].display.screenElements['SelectedALT-symbol'].show();
                                flightdeck[c].display.screenElements['SelectedALT-bug'].show();
                                flightdeck[c].display.screenElements['SelectedALT-bg'].show();
                            }
                            flightdeck[c].display.updateSelectedALT();
                        }
            }, 0, 2);

    prop = '/gear/gear/wow';
    data.listeners[prop] = setlistener(prop,
            func foreach (var c; keys(flightdeck))
                if (flightdeck[c].role == 'PFD')
                    flightdeck[c].display.updateXPDR(),
            0, 0);

    prop = '/instrumentation/altimeter/setting-inhg';
    data.listeners[prop] = setlistener(prop,
            func foreach (var c; keys(flightdeck))
                if (flightdeck[c].role == 'PFD')
                    flightdeck[c].display.updateBARO(), 0, 2);

    prop = '/autopilot/route-manager/signals/edited';
    data.listeners[prop] = setlistener(prop,
            func foreach (var c; keys(flightdeck))
                flightdeck[c].map.layers.route.onFlightPlanChange(),
                0, 1);

    prop = '/autopilot/route-manager/current-wp';
    data.listeners[prop] = setlistener(prop,
            func (n) foreach (var c; keys(flightdeck))
                    flightdeck[c].map.layers.route.onCurrentWaypointChange(n),
                0, 1);

    prop = '/autopilot/route-manager/active';
    data.listeners[prop] = setlistener(prop,
            func foreach (var c; keys(flightdeck))
                    flightdeck[c].map.layers.route.onCurrentWaypointChange(props.globals.getNode('/autopilot/route-manager/current-wp')),
                0, 1);
}

var deviceClass = {
    new: func (name) {
        var m = { parents: [ deviceClass ] };
        m.name = name;
        m.role = substr(name, 0, 3);
        m.node = zkv.getNode(name, 1);
        m.data = {};
        m.timers = {};
        foreach (var v; ['Vx', 'Vy', 'Vr', 'Vglide'])
            m.data[v ~ '-visible'] = 1;
        foreach (var v; ['screen-object', 'screen-view', 'screen-size'])
            m.data[v] = getprop('/instrumentation/zkv1000/' ~ name ~ '/' ~ v);

        m.display  = displayClass.new(m);
        m.softkeys = softkeysClass.new(m);
        m.buttons  = buttonsClass.new(m);
        m.knobs    = knobsClass.new(m);
        m.map      = mapClass.new(m);
        m.windows  = pageClass.new(m);

        if (! contains(data.timers, 'map')) {
            data.timers.map = maketimer(1, m, func {
                    foreach (var d; keys(flightdeck))
                        flightdeck[d].map.update();
                    var gspd = getprop('/velocities/groundspeed-kt');
                    if (gspd != 0)
                        var next = (me.data['range-nm']/(gspd/3600))/(me.display.display.get('view[1]')/2);
                    else
                        var next = 10;
                    if (next > 10)
                        next = 10;
                    data.timers.map.restart(next);
                });
            data.timers.map.singleShot = 1;
            data.timers.map.start();
        }
        if (getprop('/instrumentation/tcas/serviceable') != nil) {
            m.data.tcas = 0;
            if (!contains(data.timers, 'tcas')) {
                data.timers.tcas = maketimer ( 1,
                    func {
                        var tcas_dirty = [];
                        var _range = 6;
                        var _minLevel = -1;
                        foreach (var ac; props.globals.getNode("/ai/models").getChildren("multiplayer")) {
                            if (ac.getValue("valid")) {
                                var range = ac.getNode("radar/range-nm").getValue();
                                if (range != nil) {
                                    if (debug.isnan(range) == 0) {
                                        if ( (range > 0) and (range <= _range) ) {
                                            var nTcasThreat = ac.getNode("tcas/threat-level");
                                            if (nTcasThreat != nil) {
                                                var level = nTcasThreat.getValue();
                                                if (level > _minLevel) {
                                                    var lat     = ac.getNode("position/latitude-deg").getValue();
                                                    var lon     = ac.getNode("position/longitude-deg").getValue();
                                                    var aAlt    = ac.getNode("position/altitude-ft").getValue();
                                                    var vs      = ac.getNode("velocities/vertical-speed-fps").getValue();
                                                    var alt     = math.floor(((aAlt - data.alt) / 100) + 0.5);
                                                    if (debug.isnan(lat) == 0 and
                                                        debug.isnan(lon) == 0 and
                                                        debug.isnan(vs)  == 0 and
                                                        debug.isnan(alt) == 0) {
                                                            append(tcas_dirty, {
                                                                lat: lat,
                                                                lon: lon,
                                                                vs: vs,
                                                                alt: alt,
                                                                level: level,
                                                            });
                                                    } } } } } } } }
                        data.tcas = tcas_dirty;
                    }
                );
                data.timers.tcas.start();
            }
        }
        else {
            delete(m.softkeys.bindings.PFD.INSET, 'TRAFFIC');
            delete(m.softkeys.bindings.MFD.MAP,   'TRAFFIC');
        }
        m.display.showInitProgress();

        setprop('/instrumentation/zkv1000/' ~ m.name ~ '/status', 1);
        msg(m.name ~ ' switched on!');
        return m;
    },
};

var powerOn = func {
    foreach (var freq; keys(data.timers))
        data.timers[freq].start();

    foreach (var name; keys(flightdeck))
        if (zkv.getNode(name) != nil)
#            thread.newthread(func {
                flightdeck[name] = deviceClass.new(name);
#            });
    settimer(setListeners, 5);
}
